//=============================================================================
//
//
//
//
//
//=============================================================================
#define		ORBITER_MODULE
#include	"math.h"
#include	"orbitersdk.h"
#include	"stdio.h"
#include	"soyuz_reentry_shield.h"

HINSTANCE	h_DLL;

const		double		EMPTY_MASS = 100;

const		VECTOR3		TP1 = {0.0, -1.0, -0.2};
const		VECTOR3		TP2 = {-cos(30*RAD), sin(30*RAD), -0.2};
const		VECTOR3		TP3 = {cos(30*RAD), sin(30*RAD), -0.2};

const		VECTOR3		SC_REF = {0, 0, -0.29};
const		VECTOR3		SC_DIR = {0, 0, 1};
const		VECTOR3		SC_ROT = {1, 0, 0};

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
DLLCLBK	void InitModule(HINSTANCE hModule)
{
	h_DLL = hModule;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
DLLCLBK void ExitModule(HINSTANCE hModule)
{

}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
soyuz_reentry_shield::soyuz_reentry_shield(OBJHANDLE hObj, int fmodel): VESSEL2(hObj, fmodel)
{
	
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_reentry_shield::clbkLoadStateEx(FILEHANDLE scn, void *status)
{
	char *line;

	while (oapiReadScenario_nextline(scn, line))
	{
		if (!strnicmp (line, "MESHNAME", 8))
		{
			sscanf (line+8, "%s", &MeshName);
		}

		ParseScenarioLineEx(line, status);
	}

	hsoyuz_reentry_shield = oapiLoadMeshGlobal(MeshName);
	AddMesh(hsoyuz_reentry_shield);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_reentry_shield::clbkSaveState(FILEHANDLE scn)
{
	VESSEL2::clbkSaveState(scn);
	oapiWriteScenario_string(scn, "MESHNAME", MeshName);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_reentry_shield::clbkSetClassCaps(FILEHANDLE cfg)
{
	SetSize(1.0);
	SetEmptyMass(EMPTY_MASS);
	SetSurfaceFrictionCoeff(1e5, 1e5);
	SetTouchdownPoints(TP1, TP2, TP3);

	hCapsule = CreateAttachment(true,
			 				    SC_REF,
								SC_DIR,
								SC_ROT,
								"Capsule",
								false);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_reentry_shield::clbkPostStep(double simt, double SimDT, double mjd)
{
	
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_reentry_shield::clbkVisualCreated(VISHANDLE visual, int refcount)
{
	if (refcount > 1) return;
	vis = visual;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_reentry_shield::clbkVisualDestroyed(VISHANDLE visual, int refcount)
{
	if (visual == vis) vis = NULL;
}


//=============================================================================
//
//=============================================================================
DLLCLBK VESSEL *ovcInit(OBJHANDLE hvessel, int flightmodel)
{
	return new soyuz_reentry_shield(hvessel, flightmodel);
}

DLLCLBK void ovcExit(VESSEL *vessel)
{
	if (vessel) delete (soyuz_reentry_shield*) vessel;
}



